% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tuner.R
\name{run_tuner}
\alias{run_tuner}
\title{Runs the student-facing feedback app}
\usage{
run_tuner(
  app_title,
  soln_templates_dir,
  knit_wd,
  tabs = c("lint", "html", "correctness"),
  lint_list,
  corr_cols_to_drop = c(1, 2, 4, 5),
  max_time = 120,
  summary_header = "# Summary Output",
  permission_to_install = FALSE,
  ...
)
}
\arguments{
\item{app_title}{A character string of the title of the app.}

\item{soln_templates_dir}{This should be the directory containing all
solution templates. Solution templates are Rmd files.}

\item{knit_wd}{The working directory for knitting (to HTML).}

\item{tabs}{A character vector of type of check to be done}

\item{lint_list}{A list of lints (from lintr package) to be run on the 
uploaded script. If missing, a default list of lints is run. See the 
details section.}

\item{corr_cols_to_drop}{This should be an integer vector of columns to drop 
from the correctness check. By default, the columns corresponding to filename,
timestamp, run-time timing and memory are dropped.}

\item{max_time}{The maximum time (in seconds) allocated to rendering before 
failing. This is passed on to \code{render_one}.}

\item{summary_header}{This the header to search for when generating the 
description for the correctness check.}

\item{permission_to_install}{This is the argument to toggle for auto 
installation of libraries. Default is set to FALSE.}

\item{...}{Extra arguments passed on to runApp from shiny. Useful for
specifying port, etc.}
}
\value{
This function is run for its side-effect.
}
\description{
This function runs the shiny app that students submit to in order to
obtain feedback on their Rmd submission file.
}
\details{
If the \code{lint_list} argument is missing, the following list of 
lints is run:
\enumerate{
  \item T_and_F_symbol_linter,
  \item assignment_linter,
  \item brace_linter,
  \item commas_linter,
  \item equals_na_linter,
  \item function_left_parentheses_linter,
  \item infix_spaces_linter,
  \item line_length_linter,
  \item no_tab_linter,
  \item absolute_path_linter,
  \item pipe_continuation_linter,
  \item spaces_inside_linter,
  \item trailing_blank_lines_linter,
  \item trailing_whitespace_linter,
  \item unneeded_concatenation_linter
}
The full list of available lints can be found here: \code{\link[lintr]{linters}}.
}
