% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_list_get_all}
\alias{am_list_get_all}
\title{Get all conflicting values at a list position}
\usage{
am_list_get_all(doc, obj, pos, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a list)}

\item{pos}{Numeric index (1-based, like R vectors)}

\item{heads}{Optional list of change hashes (raw vectors) for historical
query. If \code{NULL} (default), uses the current state.}
}
\value{
A list of all values at the position. Returns an empty list if the
position does not exist.
}
\description{
Returns all values stored at a list position, including conflicts from
concurrent edits. When there are no conflicts, the list contains
a single element (the winning value).
}
\examples{
doc <- am_create()
doc$items <- list("a", "b", "c")
items <- doc$items

# Single value (no conflict)
values <- am_list_get_all(doc, items, 1)
values

am_close(doc)

}
