% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_text_content}
\alias{am_text_content}
\title{Get text content from a text object}
\usage{
am_text_content(text_obj)
}
\arguments{
\item{text_obj}{An Automerge text object ID}
}
\value{
Character string with the full text
}
\description{
Retrieve the full text content from a text object as a string.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "doc", am_text("Hello"))
text_obj <- am_get(doc, AM_ROOT, "doc")
text_obj

text <- am_text_content(text_obj)
text  # "Hello"

am_close(doc)

}
