% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extracting_distribution.R
\name{feat_reorder}
\alias{feat_reorder}
\title{Reorder \code{feat_dist} rows to match preprocessed data}
\usage{
feat_reorder(feat_dist, data)
}
\arguments{
\item{feat_dist}{Data frame from \code{\link[=extracting_distribution]{extracting_distribution()}}.}

\item{data}{Data frame of the \strong{original (not preprocessed)} variables.}
}
\value{
The input \code{feat_dist}, reordered to align with \code{data}.
}
\description{
Ensures row order in \code{feat_dist} matches the \strong{column prefix order} in the
preprocessed (dummy-coded) training data. This assumes dummy columns are
named as \verb{<original_name>_<level>} and therefore start with the original
variable name.
}
\examples{
# Small toy dataset
data_example <- data.frame(
  cont = rnorm(5),
  bin  = c(0, 1, 0, 1, 1),
  cat  = factor(c("A", "B", "C", "A", "C"))
)

# Extract feature distributions in original column order
feat_dist <- extracting_distribution(data_example)

# Suppose preprocessing (e.g., dummy coding) reordered the columns
data_reordered <- data_example[, c("cat", "cont", "bin")]

# Reorder feat_dist rows to match the preprocessed data columns
feat_dist_reordered <- feat_reorder(feat_dist, data_reordered)
feat_dist_reordered

}
\seealso{
\code{\link[=extracting_distribution]{extracting_distribution()}}, \code{\link[=set_feat_dist]{set_feat_dist()}}
}
