% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{save_credentials}
\alias{save_credentials}
\alias{set_credentials}
\alias{delete_saved_credentials}
\alias{restore_credentials}
\title{Save/restore/manage session credentials}
\usage{
save_credentials()

set_credentials(credentials, save.previous = TRUE)

delete_saved_credentials(all = FALSE)

restore_credentials(pop = TRUE, root = FALSE)
}
\arguments{
\item{credentials}{list, credentials as received from the REST API
call, they should contain to following elements:
\code{AccessKeyId}, \code{SecretAccessKey} and
\code{SessionToken})}

\item{save.previous}{logical, if \code{TRUE} the current
credentials are saved first using \code{save_credentials}
before the new credentials are applied.}

\item{all}{logical, if \code{TRUE} then removes all credentials
from the stack, otherwise only the last ones.}

\item{pop}{logical, if \code{TRUE} then the credentials are
restored and then removed from the stack.}

\item{root}{logical, if \code{FALSE} then last saved credentials
are used. if \code{TRUE} then goes down the stack to the first
saved credentials. If both \code{root} and \code{pop} are
\code{TRUE} then all credentials are removed from the stack.}
}
\description{
The following functions manage the environment
    variables \code{AWS_ACCESS_KEY_ID},
    \code{AWS_SECRET_ACCESS_KEY} and \code{AWS_SESSION_TOKEN} used
    for credentials for all AWS API calls.

    \code{save_credentials} saves the current credentials to a
    stack of credentials kept in the session. Always returns
    \code{TRUE}.

    \code{restore_credentials} restores the last saved credentials
    and pops them off the stack.

    \code{delete_saved_credentials} removes the last saved
    credentials without using them.

    \code{set_credentials} uses credentials list as supplied by the
    REST API and makes them current by assigning their values to
    the corresponding \code{AWS_*} environment variables. If
    \code{save.previous} is \code{TRUE} then the currently used
    credentials are first saved on the stack ebfore being replaced
    with the new ones.

    Most functions in the \code{STS} section call
    \code{set_credentials()} automatically if \code{use = TRUE} is
    set.
}
\details{
Since \code{aws.iam} version 0.1.8 the credentials are
    kept on a stack, so it is possible to use
    \code{save_credentials()} several times without restoring
    them. This allows role chaining. At the end of a chained
    session it is possible to get back to the main credentials using
    \code{restore_credentials(pop=TRUE, root=TRUE)}.
}
