% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{download_files_from_run}
\alias{download_files_from_run}
\title{Download files from a run}
\usage{
download_files_from_run(
  run,
  prefix = NULL,
  output_directory = NULL,
  output_paths = NULL,
  batch_size = 100L
)
}
\arguments{
\item{run}{The \code{Run} object.}

\item{prefix}{A string of the the filepath prefix (folder name) from
which to download all artifacts. If not specified, all the artifacts
in the run record will be downloaded.}

\item{output_directory}{(Optional) A string of the directory that all
artifact paths use as a prefix.}

\item{output_paths}{(Optional) A list of strings of the local filepaths
where the artifacts will be downloaded to.}

\item{batch_size}{An int of the number of files to download per batch.}
}
\value{
None
}
\description{
Download files from the run record. You can download any files that
were uploaded to the run record via \code{upload_files_to_run()} or
\code{upload_folder_to_run()}, or any files that were written out to
the \code{./outputs} or \code{./logs} folders during a run.
}
\seealso{
\code{\link[=download_file_from_run]{download_file_from_run()}}
}
