% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loops.R
\name{process_one_directory}
\alias{process_one_directory}
\title{Process One Directory of 'BabyTime' Activity Files}
\usage{
process_one_directory(directory, remove_txts = TRUE, verbose = TRUE)
}
\arguments{
\item{directory}{directory with activity files in it}

\item{remove_txts}{boolean. whether to remove txt files before processing}

\item{verbose}{boolean. print out processing details?}
}
\value{
Clean BT List DB object (and also write it to the `out` RDS file)
}
\description{
Only works with with .zip files
}
\examples{
data_dir <- system.file('extdata', package = 'babyTimeR')
if (file.exists('parsed_data.RDS')) {
    baby_dann_db <- readRDS('parsed_data.RDS')
} else {
    baby_dann_db <- process_one_directory(
        directory = data_dir,
        remove_txts = FALSE
    )
}
}
