% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_data.R
\name{screen_data}
\alias{screen_data}
\alias{data.clinical}
\alias{data.screen}
\title{Toy Dataset}
\format{
Two datasets are provided. 

\code{data.screen} is a data.frame containing
  the following screening information for 89 participants (287 assessments)
  \itemize{
    \item{id:} A character. Participant ids.
    \item{age_assess:} A numeric. The participant age as time of assessment.
    \item{disease_detected:} An integer. 1 = disease detected at assessment; 
    0 otherwise
  }
  
\code{data.clinical} is a data.frame containing the following information for 89 
  participants.
  \itemize{
    \item{id:} A character. Participant ids.
    \item{age_entry:} A numeric. The participant age as time of study entry.
    \item{endpoint_type:} A character. One of \{"clinical", "preclinical", "censored"\},
    indicating if participant was diagnosed with the disease in the clinical
    compartment, was diagnosed in the pre-clinical compartment, or was
    censored.
    \item{age_endpoint:} A numeric. The participant's age at time the endpoint
    was ascertained.
  }
}
\usage{
data(screen_data)
}
\description{
This toy dataset is provided to facilitate examples and provide an
  example of the required input format. Though the data were simulated
  under a scenario similar to a real-world breast cancer screening trial,
  they should not be interpreted as representing true trial data.
}
\keyword{datasets}
