% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat_test}
\alias{stat_test}
\title{statistical test which returns a extensible tibble}
\usage{
stat_test(
  df,
  y,
  x,
  .by = NULL,
  trans = "identity",
  paired = FALSE,
  paired_by = NULL,
  alternative = "two.sided",
  exclude_func = NULL,
  method = "wilcoxon",
  ns_symbol = "NS",
  digits = 2
)
}
\arguments{
\item{df}{tibble}

\item{y}{value}

\item{x}{sample test group}

\item{.by}{super-group}

\item{trans}{scale transformation}

\item{paired}{paired samples or not}

\item{paired_by}{a column for pair}

\item{alternative}{one of "two.sided" (default), "greater" or "less"}

\item{exclude_func}{a function has two arguments and return bool value, used
if paired=TRUE and will keep the comparation pairs which return TRUE by this
function.}

\item{method}{test method, 'wilcoxon' as default, one of \code{t|wilcoxon}}

\item{ns_symbol}{symbol of nonsignificant, 'NS' as default}

\item{digits}{significant figure digits of p value
If the data pair of a single test returns TRUE, then exclude this pair}
}
\value{
test result tibble
}
\description{
statistical test which returns a extensible tibble
}
\examples{
stat_test(mini_diamond, y = price, x = cut, .by = clarity)
}
