% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_utils.R
\name{ISO_8601}
\alias{ISO_8601}
\alias{as_ISO8601_character}
\alias{coerce_ISO8601}
\title{Coerce to ISO 8601}
\usage{
as_ISO8601_character(datetime)

coerce_ISO8601(date)
}
\arguments{
\item{datetime}{Character string. The datetime to coerce.}

\item{date}{Character string. The date to coerce.}
}
\value{
Character string in ISO 8601 format.
}
\description{
Coerce dates or datetimes to ISO 8601 format for Bamboo HR REST API.
}
\details{
Input can be simply given as a character string. See \link{date_formats} for
allowed format types.
}
\section{Functions}{
\itemize{
\item \code{as_ISO8601_character()}: Coerce datetime into ISO8601 format. This will convert
represent the datetime relative to UTC using \code{+} notation. Milliseconds are
removed.

\item \code{coerce_ISO8601()}: Coerce a date to ISO8601 format. This will convert the date
into UTC (applying \code{Z} notation) and remove any milliseconds.

}}
\keyword{internal}
