% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Bamboo API get request wrapper for BambooHR tables}
\usage{
get_table(employee_id, table_name, api_version = "v1")
}
\arguments{
\item{employee_id}{Character of employee ID to return. A special employee ID of "all",
can also be used which will cause the API to return all rows for all employees in the table.
When specifying "all" employees, the result will include inactive and terminated employees.
In addition, the special employee ID of 0 is the employee ID associated
with the API key being used.}

\item{table_name}{Character of table name. Valid table names can be found in
the "parent_alias" column return by \code{get_meta("tables")}.}

\item{api_version}{(optional) - Version of API to use to make request. Default is "v1".}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} object.
}
\description{
Returns a data structure representing all the table rows for
a given employee and table combination.
}
\examples{
\dontrun{
get_table(employee_id = "all", table_name = "jobInfo")

get_table(employee_id = 0, table_name = "jobInfo")

get_table(0, "compensation")
}
}
\references{
\url{https://documentation.bamboohr.com/reference#get-employee-table-row-1}
}
