% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_request.R
\name{get_request}
\alias{get_request}
\title{Bamboo HR API get request wrapper}
\usage{
get_request(url, key = .get_api_key(), verbose = FALSE)
}
\arguments{
\item{url}{Character url of the get request.}

\item{key}{Character api key for bambooHR. Register in your account, see \href{https://documentation.bamboohr.com/docs#section-authentication}{authentication} for details.
Default value is obtained from \code{options("bambooHR.api_key")}. This can also be set in the config file using \code{config_setup("api key", "company domain")}.}

\item{verbose}{Logical. Should the function provide verbose messaging back on each step?}
}
\value{
A \code{\link[httr:response]{httr::response()}} object.
}
\description{
Submits get requests to the Bamboo API.
}
\examples{
\dontrun{
res <- get_request("https://api.bamboohr.com/api/gateway.php/your_company/v1/employees/0/")
httr::content(res, "text")
}


}
