% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_classes.R
\docType{class}
\name{g_area-class}
\alias{g_area-class}
\alias{g_area}
\title{S4 Class Hierarchy for BAM (Biotic-Abiotic-Movement) Modeling}
\description{
This documentation describes the S4 class system used in the \code{bamm} package
for modeling species distributions using the BAM (Biotic-Abiotic-Movement) framework.
The classes organize data and results for ecological niche modeling, dispersal
simulation, and biodiversity analysis.

The foundational class containing geographic coordinates and optional eigen
analysis results for spectral graph methods.
}
\section{Slots}{

\describe{
\item{\code{coordinates}}{A numeric matrix with two columns (x, y) representing
geographic coordinates of non-NA cells}

\item{\code{eigen_vec}}{Matrix containing eigenvectors from adjacency matrix analysis}

\item{\code{eigen_val}}{Numeric vector containing eigenvalues from adjacency matrix analysis}
}}

\seealso{
\code{\link{setA-class}}, \code{\link{setM-class}}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
