% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_utils.R
\name{aw_var}
\alias{aw_var}
\title{Variance of policy value estimator via non-contextual adaptive weighting.}
\usage{
aw_var(scores, estimate, policy, evalwts = NULL)
}
\arguments{
\item{scores}{Numeric matrix. AIPW scores, shape \code{[A, K]}. Must not contain NA values.}

\item{estimate}{Numeric scalar. Policy value estimate.}

\item{policy}{Numeric matrix. Policy matrix \eqn{\pi(X_t, w)}, shape \code{[A, K]}. Must have the same shape as \code{scores} and must not contain NA values.}

\item{evalwts}{Optional numeric vector. Non-contextual adaptive weights \eqn{h_t}, length \code{A}, or \code{NULL}.}
}
\value{
Numeric scalar. Variance of policy value estimate.
}
\description{
Computes the variance of a policy value estimate based on AIPW scores, a policy matrix, and
non-contextual adaptive weights.
}
\examples{
scores <- matrix(c(0.5, 0.8, 0.6,
                   0.3, 0.9, 0.2,
                   0.5, 0.7, 0.4,
                   0.8, 0.2, 0.6), ncol = 3, byrow = TRUE)
policy <- matrix(c(0.2, 0.3, 0.5,
                   0.6, 0.1, 0.3,
                   0.4, 0.5, 0.1,
                   0.2, 0.7, 0.1), ncol = 3, byrow = TRUE)
estimate <- aw_estimate(scores = scores, policy = policy, evalwts = c(0.5, 1, 0.5, 1.5))
aw_var(scores = scores, estimate = estimate, policy = policy, evalwts = c(0.5, 1, 0.5, 1.5))

}
