% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{update_thompson}
\alias{update_thompson}
\title{Update linear Thompson Sampling model.}
\usage{
update_thompson(ws, yobs, model, xs = NULL, ps = NULL, balanced = NULL)
}
\arguments{
\item{ws}{Integer vector. Indicates which arm was chosen for observations at each time \code{t}. Length \code{A}, where \code{A} is the number of observations. Must not contain NA values.}

\item{yobs}{Numeric vector. Observed outcomes, length \code{A}. Must not contain NA values.}

\item{model}{List. Contains the parameters of the LinTSModel.}

\item{xs}{Optional matrix. Covariates of shape \code{[A, p]}, where \code{p} is the number of features, if the LinTSModel is contextual. Default is \code{NULL}. Must not contain NA values.}

\item{ps}{Optional matrix. Probabilities of selecting each arm for each observation, if the LinTSModel is balanced. Default is \code{NULL}.}

\item{balanced}{Logical. Indicates whether to use balanced Thompson Sampling. Default is \code{NULL}.}
}
\value{
A list containing the updated parameters of the LinTSModel.
}
\description{
Updates the parameters of a linear Thompson Sampling model for multi-armed bandit problems based on new observations.
}
\examples{
set.seed(123)
model <- LinTSModel(K = 5, p = 3, floor_start = 1, floor_decay = 0.9, num_mc = 100,
                    is_contextual = TRUE)
A <- 1000
ws <- numeric(A)
yobs <- numeric(A)
model <- update_thompson(ws = ws, yobs = yobs, model = model)

}
