% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-rity.R
\encoding{UTF-8}
\name{model.rity.apply}
\alias{model.rity.apply}
\title{Use RITY}
\arguments{
\item{tmin, tmean, tmax}{Daily minimum/mean/maximum temperatures in °C.
For the \code{development} submodel, the parameter that is obligatory depends on
\code{mode}.}

\item{daylength}{Length of the day in hours. Can be created with
\code{\link[=create_daylength_rst]{create_daylength_rst()}} or \code{\link[=create_daylength_rst]{create_daylength_rst()}}.}

\item{mode}{Specifies which temperature should be used to calculate the
development. Can be \code{min}, \code{mean} or \code{max}.}

\item{.submodels, .onset, .diapause, .mortality, ...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}
}
\value{
The function returns a phenology. Look \link[=analyse.phenology]{here} to find out how it can be analysed.
}
\description{
This page describes the usage of RITY with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
RITY (also called RITY-2) was published by \insertCite{Ogris2019;textual}{barrks} and
parametrized for \emph{Ips typographus} in Slovenia.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply RITY and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("rity", ..., tmin = NULL, tmean = NULL, tmax, daylength, mode = 'max')

# calculate submodels separately
phenology("rity", ..., .submodels = 'onset', tmax)
phenology("rity", ..., .submodels = 'diapause', daylength)
phenology("rity", ..., .submodels = 'mortality', tmax)
phenology("rity", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmin = NULL, tmean = NULL, tmax = NULL, mode = 'max')
}\if{html}{\out{</div>}}
}
\section{Functioning}{


In the following, the basic functioning of RITY is explained.
\itemize{
\item \strong{Onset}: See \link[=model.phenips.apply]{PHENIPS}.
\item \strong{Development}: Based on \link[=model.phenips.apply]{PHENIPS} with a few modifications:
\itemize{
\item The optimum curve is calculated according to
\insertCite{Wermelinger1998;textual}{barrks} without
simplification.
\item The minimum, mean or maximum bark temperature can be used to calculate
the development. These temperatures depend only on the respective air temperatures.
}
\item \strong{Diapause}: See \link[=model.phenips.apply]{PHENIPS}.
\item \strong{Mortality}: See \link[=model.phenips.apply]{PHENIPS}.
}

Look \link[=model.rity.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.rity.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.chapy.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.phenips_clim.apply}}
}
\concept{phenology applications}
