% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimpPlot.R
\name{vimpPlot}
\alias{vimpPlot}
\title{vimpPlot}
\usage{
vimpPlot(trees, type = "prop", plotType = "barplot", metric = "median")
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{type}{What value to return. Either the raw count 'count'
or the proportions 'prop' averaged over iterations.}

\item{plotType}{Which type of plot to return. Either a barplot 'barplot' with the
quantiles shown as a line, a point plot with the quantiles shown as a gradient 'point', or a
letter-value plot 'lvp'.}

\item{metric}{Whether to show the 'mean' or 'median' importance values. Note, this has
no effect when using plotType = 'lvp'.}
}
\value{
A plot of variable importance.
}
\description{
Plot the variable importance for a BART model with the 25% and 75%
quantile.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 vimpPlot(trees = trees_data, plotType = 'point')
}

}
