% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baselinenowcast_df-class.R
\name{assert_baselinenowcast_df}
\alias{assert_baselinenowcast_df}
\title{Assert validity of \code{baselinenowcast_df} objects}
\usage{
assert_baselinenowcast_df(data)
}
\arguments{
\item{data}{A \link{baselinenowcast_df} object to check for validity.}
}
\value{
Returns \code{NULL} invisibly. Throws an error if validation fails.
}
\description{
Assert validity of \code{baselinenowcast_df} objects
}
\examples{
# Create a valid baselinenowcast_df object
valid_df <- data.frame(
  reference_date = as.Date("2024-01-01") + 0:4,
  pred_count = c(10, 15, 12, 18, 20),
  draw = 1,
  output_type = "point"
)
class(valid_df) <- c("baselinenowcast_df", "data.frame")

# Validate the object
assert_baselinenowcast_df(valid_df)
}
\seealso{
Main nowcasting interface functions
\code{\link{baselinenowcast}()},
\code{\link{baselinenowcast.data.frame}()},
\code{\link{baselinenowcast.reporting_triangle}()},
\code{\link{baselinenowcast_df-class}},
\code{\link{new_baselinenowcast_df}()}
}
\concept{baselinenowcast_df}
