% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocate_reference_times.R
\name{.check_against_requirements}
\alias{.check_against_requirements}
\title{Check target size against number of reference times available and the number
required}
\usage{
.check_against_requirements(
  n_ref_times,
  n_required,
  n_target,
  n_min_delay,
  n_min_retro_nowcasts,
  scale_factor,
  max_delay
)
}
\arguments{
\item{n_ref_times}{Integer indicating the number of reference times
available}

\item{n_required}{Integer indicating the number need for both delay and
uncertainty}

\item{n_target}{Integer indicating the target number of reference times.}

\item{n_min_delay}{Integer indicating the number needed for delay
estimation.}

\item{n_min_retro_nowcasts}{Integer indicating the number needed for
uncertainty estimation.}

\item{scale_factor}{Numeric value indicating the multiplicative factor on
the maximum delay to be used for estimation of delay and uncertainty.
Default is \code{3}.}
}
\value{
\code{n_used} Integer indicating how many reference times will be
used
}
\description{
Check target size against number of reference times available and the number
required
}
\keyword{internal}
