% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty.R
\name{fit_nb}
\alias{fit_nb}
\title{Fit a negative binomial to a vector of observations and expectations}
\usage{
fit_nb(x, mu)
}
\arguments{
\item{x}{Vector of observed values.}

\item{mu}{Vector of expected values.}
}
\value{
the maximum likelihood estimate of the dispersion
}
\description{
Takes in a vector of observations and a vector of expectations and performs
a MLE estimator to estimate the dispersion parameter of a negative
binomial. This code was adapted from code written (under an MIT license)
by the Karlsruhe Institute of Technology RESPINOW German Hospitalization
Nowcasting Hub.
Modified from: \url{https://github.com/KITmetricslab/RESPINOW-Hub/blob/7fab4dce7b559c3076ab643cf22048cb5fb84cc2/code/baseline/functions.R#L404} #nolint
}
\examples{
obs <- c(4, 8, 10)
pred <- c(3.1, 7.2, 11)
disp <- fit_nb(obs, pred)
disp
}
\seealso{
Observation error estimation functions
\code{\link{estimate_uncertainty}()},
\code{\link{fit_by_horizon}()}
}
\concept{estimate_observation_error}
