% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_inter.R
\name{b_inter}
\alias{b_inter}
\title{N-way interaction basis}
\usage{
b_inter(
  ...,
  depth = 2,
  stdize = c("symbox", "box", "scale", "none"),
  shift = NULL,
  scale = NULL
)
}
\arguments{
\item{...}{The variable(s) to build features for. A single data frame or
matrix may be provided as well. Missing values are not allowed.}

\item{depth}{The maximum interaction depth. The default is 2, which means
that all pairwise interactions are included.}

\item{stdize}{How to standardize the predictors, if at all. The default
\code{"scale"} applies \code{scale()} to the input so that the features have mean
zero and unit variance, \code{"box"} scales the data along each dimension
to lie in the unit hypercube, and \code{"symbox"} scales the data along each
dimension to lie in \eqn{[-0.5, 0.5]^d}.}

\item{shift}{Vector of shifts, or single shift value, to use. If provided,
overrides those calculated according to \code{stdize}.}

\item{scale}{Vector of scales, or single scale value, to use. If provided,
overrides those calculated according to \code{stdize}.}
}
\value{
A matrix with the rescaled and interacted features.
}
\description{
Generates a design matrix that contains all possible interactions of the
input variables up to a specified maximum depth.
The default \code{"symbox"} standardization, which maps inputs to
\eqn{[-0.5, 0.5]^d}, is strongly recommended, as it means that the interaction
terms will have smaller variance and thus be penalized more by methods like
the Lasso or ridge regression (see Gelman et al., 2008).
}
\examples{
# default: all pairwise interactions
lm(mpg ~ b_inter(cyl, hp, wt), mtcars)

# how number of features depends on interaction depth
for (d in 2:6) {
    X = with(mtcars, b_inter(cyl, disp, hp, drat, wt, depth=d))
    print(ncol(X))
}

}
\references{
Gelman, A., Jakulin, A., Pittau, M. G., & Su, Y. S. (2008). A
weakly informative default prior distribution for logistic and other
regression models.
}
