% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{mig.diagnose}
\alias{mig.diagnose}
\alias{bayesMig.convergence}
\alias{mig.raftery.diag}
\alias{estimate.a.hw}
\title{MCMC convergence diagnostics}
\usage{
mig.diagnose(
  sim.dir,
  thin = 80,
  burnin = 2000,
  express = FALSE,
  country.sampling.prop = NULL,
  keep.thin.mcmc = FALSE,
  verbose = TRUE
)

mig.raftery.diag(
  mcmc = NULL,
  sim.dir = NULL,
  burnin = 0,
  country = NULL,
  par.names = NULL,
  par.names.cs = NULL,
  country.sampling.prop = 1,
  verbose = TRUE,
  ...
)

estimate.a.hw(mcmc, burnin = 0, thin = NULL)
}
\arguments{
\item{sim.dir}{Directory with MCMC simulation results.}

\item{thin}{Thinning interval.}

\item{burnin}{Number of iterations to discard from the beginning of the parameter traces.}

\item{express}{Logical. If \code{TRUE}, the convergence diagnostic is run only on the country-independent
parameters. If \code{FALSE}, the country-specific parameters are included in the diagnostics. The number of
countries can be controlled by \code{country.sampling.prop}.}

\item{country.sampling.prop}{Proportion of countries to include in the diagnostics. If it is \code{NULL} and
\code{express=FALSE}, all countries are included. Setting a number between 0 and 1 will determine the proportion of countries
to be randomly sampled. For long Markov chains, this argument may significantly influence the runtime of this function.}

\item{keep.thin.mcmc}{Logical. If \code{TRUE}, the thinned traces used for computing the diagnostics are stored on disk.}

\item{verbose}{Logical value. Switches log messages on and off.}

\item{mcmc}{A \code{\link{bayesMig.mcmc}} or \code{\link{bayesMig.mcmc.set}} object. 
If not given, the object is loaded from the simulation directory given by 
\code{sim.dir}.}

\item{country}{Name or code of a country. If it is given, only country-specific 
parameters parameters of that country are considered.}

\item{par.names}{Names of country-independent parameters for which the Raftery 
diagnostics should be computed. By default all parameters are used.}

\item{par.names.cs}{Names of country-specific parameters for which the Raftery 
diagnostics should be computed. By default all parameters are used.}

\item{\dots}{Additional arguments passed to the \code{\link{mig.coda.list.mcmc}} function.}
}
\value{
\code{mig.diagnose} returns an object of class \code{bayesMig.convergence} 
    containing summaries of the convergence check inputs and outputs. It has the 
    same structure as \code{\link[bayesTFR]{bayesTFR.convergence}}. 
    In addition it has an element \code{a.hw.est} which is the estimated value for 
    the \code{a.half.width} argument in \code{\link{run.mig.mcmc}}.
}
\description{
Runs convergence diagnostics of existing migration Markov chains 
    using the \code{raftery.diag} function from the \code{coda} package.
}
\details{
The \code{mig.diagnose} function invokes the \code{\link{mig.raftery.diag}} 
    function separately for country-independent parameters and for country-specific 
    parameters. It results in two possible states: red, i.e. it did not converge, and green, 
    i.e. it converged. The resulting object is stored in 
    \file{\{sim.dir\}/diagnostics/bayesMig.convergence_\{thin\}_\{burnin\}.rda} 
    and can be accessed using the function \code{\link{get.mig.convergence}}.
    
    Function \code{\link[bayesTFR]{has.mcmc.converged}} from the \pkg{bayesTFR} package 
    can be used to check if the existing diagnostics converged.

For details on the \code{mig.raftery.diag} function, see \code{\link[bayesTFR]{tfr.raftery.diag}}.

The \code{estimate.a.hw} function estimates an optimal value for the \code{a.half.width}
    argument in \code{\link{run.mig.mcmc}}.
}
\examples{
# See examples in ?bayesMig and ?get.mig.convergence

}
\seealso{
\code{\link[bayesTFR]{tfr.raftery.diag}}, \code{\link[coda]{raftery.diag}}, \code{\link{get.mig.convergence}}
}
