% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{summary.bayesMig.mcmc}
\alias{summary.bayesMig.mcmc}
\alias{summary.bayesMig.mcmc.set}
\title{Summary Statistics for Migration Markov Chain Monte Carlo}
\usage{
\method{summary}{bayesMig.mcmc}(
  object,
  country = NULL,
  par.names = NULL,
  par.names.cs = NULL,
  thin = 1,
  burnin = 0,
  ...
)

\method{summary}{bayesMig.mcmc.set}(
  object,
  country = NULL,
  chain.id = NULL,
  par.names = NULL,
  par.names.cs = NULL,
  meta.only = FALSE,
  thin = 1,
  burnin = 0,
  ...
)
}
\arguments{
\item{object}{Object of class \code{\link{bayesMig.mcmc.set}} or \code{\link{bayesMig.mcmc}}.}

\item{country}{Location name or code if a location-specific summary is desired. The code can be either numeric 
or (if locations are countries) ISO-2 or ISO-3 characters. By default, summary 
for all locations is generated.}

\item{par.names}{Country independent parameters (hyperparameters) to be included in the summary. 
The default names are given by \code{\link{mig.parameter.names}()}.}

\item{par.names.cs}{Location-specific parameters to be included in the summary.
The default names are given by \code{\link{mig.parameter.names.cs}()}.}

\item{thin}{Thinning interval. Only used if larger than the \code{thin} argument used in \code{\link{run.mig.mcmc}}.}

\item{burnin}{Number of iterations to be discarded from the beginning of each chain before computing the summary.}

\item{\dots}{Additional arguments passed to the \code{\link[coda]{summary.mcmc}} function of the \pkg{coda} package.}

\item{chain.id}{Identifiers of MCMC chains. By default, all chains are considered.}

\item{meta.only}{Logical. If it is \code{TRUE}, only meta information of the simulation is included.}
}
\value{
Return list with elements:
\describe{
\item{meta}{contains meta information about the object.}
\item{results}{contains result of \code{\link[coda]{summary.mcmc}}.}
\item{country.name}{optional; available if \code{country} is provided as argument.}
}
}
\description{
Summary of an object \code{\link{bayesMig.mcmc.set}} or \code{\link{bayesMig.mcmc}},
    computed via \code{\link{run.mig.mcmc}}.  It can be obtained either for all locations or 
    for a specific location, and either for all parameters or for specific parameters.
    The function uses the \code{\link[coda]{summary.mcmc}} function of the \pkg{coda} package.
}
\examples{
# See example in ?run.mig.mcmc
}
