% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm.R
\name{ssm}
\alias{ssm}
\title{A constructor for a Additive linear State space model.}
\usage{
ssm(
  ts,
  trend = FALSE,
  damped = FALSE,
  seasonal = FALSE,
  xreg = NULL,
  period = 0,
  genT = FALSE,
  series.name = NULL
)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{trend}{a bool value to specify a trend local level model. By default,
\code{trend = FALSE}.}

\item{damped}{a bool value to specify a damped trend local level model. By default,
\code{damped = FALSE}. If \code{trend = FALSE} then \code{damped = FALSE}
automatically.}

\item{seasonal}{a bool value to specify a seasonal local level model. By default
\code{seasonal = FALSE}.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{period}{an integer specifying the periodicity of the time series by
default the value \code{frequency(ts)} is used.}

\item{genT}{a bool value to specify for a generalized t-student SSM model.}

\item{series.name}{an optional string vector with the time series names.}
}
\value{
The function returns a list with the data for running \code{stan()}
function of \pkg{rstan} package.
}
\description{
Constructor of the \code{ets("Z","Z","Z")} object for Bayesian estimation in \pkg{Stan}.
}
\details{
By  default  the  \code{ssm()}  function generates a local level
\code{ets("A","N","N")}, or exponential smoothing model. If \code{trend = TRUE},
then  the model transforms into a  local  trend, \code{ets("A","A","N")} or Holt model
from the n\pkg{forecast} package. For damped trend models set \code{damped = TRUE}.
When \code{seasonal = TRUE}, the model becomes a seasonal local level or
\verb{ets("A","N","A")`` model from  the  \pkg{forecast} package. Finally, a Holt-Winters method or }ets("A","A","A")`,is whenever both \code{Trend} and
\code{seasonal} options are  \code{TRUE}.

The \code{genT = TRUE} defines a t-student innovations SSM model. Check, Ardia (2010))
and Fonseca, et. al (2019) for more details.

The default priors used in a \code{ssm( )} model are:

\itemize{
\item{level ~ normal(0,0.5)}
\item{Trend ~ normal(0,0.5)}
\item{damped~ normal(0,0.5)}
\item{Seasonal ~ normal(0,0.5)}
\item{sigma0 ~ t-student(0,1,7)}
\item{level1 ~ normal(0,1)}
\item{trend1 ~ normal(0,1)}
\item{seasonal1 ~ normal(0,1)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
mod1 = ssm(ipc)

# Declaring a Holt model for the ipc data.
mod2 = ssm(ipc,trend = TRUE,damped = TRUE)

# Declaring an additive Holt-Winters model for the birth data
mod3 = ssm(birth,trend = TRUE,damped = TRUE,seasonal = TRUE)

}
\references{
Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.
}
\seealso{
\code{Sarima}, \code{auto.arima}, \code{set_prior}, and \code{garch}.
}
\author{
Asael Alonzo Matamoros.
}
