% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_drift_curves}
\alias{plot_drift_curves}
\title{Plot cubic OU drift curves}
\usage{
plot_drift_curves(results, sectors = NULL)
}
\arguments{
\item{results}{List returned by \code{\link{fit_ou_nonlinear_tmg}}}

\item{sectors}{Integer vector. Sector indices to plot.
If NULL, plots all sectors.}
}
\value{
NULL invisibly. Produces a base R plot as side effect.
}
\description{
Displays the drift function for selected sectors showing mean reversion
with cubic nonlinearity.
}
\examples{
\donttest{
# 1. Create mock data
# z: vector of state deviations
z_seq <- seq(-3, 3, length.out = 100)
# drift: matrix (rows=z, cols=sectors)
drift_mat <- cbind(
  -0.5 * z_seq - 0.1 * z_seq^3, # Sector 1
  -0.8 * z_seq - 0.05 * z_seq^3 # Sector 2
)

# 2. Wrap in list structure
results_mock <- list(
  nonlinear = list(
    drift_decomp = list(
      z = z_seq,
      drift = drift_mat
    )
  )
)

# 3. Plot
plot_drift_curves(results_mock)
}

}
