% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhat.R
\name{rhat}
\alias{rhat}
\alias{rhat.bayesnecfit}
\alias{rhat.bayesmanecfit}
\title{Extract Diagnostic Quantities of 'brms' Models}
\usage{
\method{rhat}{bayesnecfit}(x, rhat_cutoff = 1.05, ...)

\method{rhat}{bayesmanecfit}(x, rhat_cutoff = 1.05, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{rhat_cutoff}{A \code{\link[base]{numeric}} vector indicating the Rhat
cut-off used to test for model convergence.}

\item{...}{Unused.}
}
\value{
A \code{\link[base]{list}} containing a vector or Rhat values
returned for each parameter for a \code{\link[brms]{brmsfit}} object,
for each of the fitted models.
}
\description{
Extract Rhat statistic that can be used to diagnose sampling behaviour
of the algorithms applied by 'Stan' at the back-end of 'brms'.
\code{x} should be of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.
}
\examples{
\dontrun{
library(bayesnec)
rhat(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
rhat(nec4param)
}
}
