% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcf.R
\name{summary.bcf}
\alias{summary.bcf}
\title{Takes a fitted bcf object produced by bcf() and produces summary stats and MCMC diagnostics.
This function is built using the coda package and meant to mimic output from rstan::print.stanfit().
It includes, for key parameters, posterior summary stats, effective sample sizes, 
and Gelman and Rubin's convergence diagnostics. 
By default, those parameters are: sigma (the error standard deviation when the weights
are all equal), tau_bar (the estimated sample average treatment effect), mu_bar
(the average outcome under control/z=0 across all observations in the sample), and
yhat_bat (the average outcome under the realized treatment assignment across all
observations in the sample).}
\usage{
\method{summary}{bcf}(
  object,
  ...,
  params_2_summarise = c("sigma", "tau_bar", "mu_bar", "yhat_bar")
)
}
\arguments{
\item{object}{output from a BCF predict run.}

\item{...}{additional arguments affecting the summary produced.}

\item{params_2_summarise}{parameters to summarise.}
}
\value{
No return value, called for side effects
}
\description{
We strongly suggest updating the coda package to our 
Github version, which uses the Stan effective size computation. 
We found the native coda effective size computation to be overly optimistic in some situations
and are in discussions with the coda package authors to change it on CRAN.
}
\examples{
\dontrun{

# data generating process
p = 3 #two control variables and one moderator
n = 250

set.seed(1)

x = matrix(rnorm(n*p), nrow=n)

# create targeted selection
q = -1*(x[,1]>(x[,2])) + 1*(x[,1]<(x[,2]))

# generate treatment variable
pi = pnorm(q)
z = rbinom(n,1,pi)

# tau is the true (homogeneous) treatment effect
tau = (0.5*(x[,3] > -3/4) + 0.25*(x[,3] > 0) + 0.25*(x[,3]>3/4))

# generate the response using q, tau and z
mu = (q + tau*z)

# set the noise level relative to the expected mean function of Y
sigma = diff(range(q + tau*pi))/8

# draw the response variable with additive error
y = mu + sigma*rnorm(n)

# If you didn't know pi, you would estimate it here
pihat = pnorm(q)

bcf_fit = bcf(y, z, x, x, pihat, nburn=2000, nsim=2000)

# Get model fit diagnostics
summary(bcf_fit)

}
}
