% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_request.R
\name{get_request}
\alias{get_request}
\title{Get JSON response from BDL API}
\usage{
get_request(dir, id, filters = NULL, ...)
}
\arguments{
\item{dir}{A directory of the dataset.}

\item{id}{A name for the dataset of interested.}

\item{filters}{A named list of filters. Names of list objects are bdl
filter names and values are vectors with specified filter values. If \code{NULL}
(default) the whole dataset is returned. See API documentation for more on filters
and limitations per query.}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A JSON raw data.
}
\description{
Retrieve data from BDL API in JSON format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be specified with filters. If no specific filters
  required, it's recommended to use data query like \code{\link{get_data_by_unit_locality}},
  than to use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
   # get_request(dir = "data/By-Variable", id = "3643")
   # get_request(dir = "data/By-Unit", id = "023200000000", filters = list(year  = c("2000","2010"), 
   #             var-Id" = c("2137","148190")))
   # get_request(dir = "data/By-Variable", id = "3643", filters = list(year = c("2000","2010"), 
   #             unit-Level" = 2, lang = "en"))
}
\keyword{database}
\keyword{utilities}
