% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdribs.R
\name{bdribs}
\alias{bdribs}
\title{bdribs (Bayesian Detection of Risk using Inference on Blinded Safety data)}
\usage{
bdribs(y, pyr, bg.events, bg.pyr, bg.rate = NULL, k = 1, p.params = list(a
  = 1, b = 1), r.params = list(mu = 0, sd = 2), adj.k = FALSE,
  mc.params = list(burn = 1000, iter = 10000, nc = 2), inf.type = 1,
  plots = TRUE, prnt = TRUE)
}
\arguments{
\item{y}{observed pooled events (combined active and control group) e.g., y = 20}

\item{pyr}{total payr exposure (combined active and control group) e.g., pyr = 2000}

\item{bg.events}{background (historical) events for the control group e.g., bg.events = 5}

\item{bg.pyr}{background (historical) pyr exposure for the control group e.g., bg.pyr = 1000}

\item{bg.rate}{when specified used as the true background rate for the control group and ignores bg.events and bg.pyr, default: bg.rate=NULL}

\item{k}{allocation ratio of treatment vs. control group, default: k=1}

\item{p.params}{paramaters of beta prior of p (used only when inf.type = 1 or = 2); default: p.param= list(a=1,b=1). See details below.}

\item{r.params}{paramaters of log-normal prior of r (used only when p.params=NULL); default: r.param= list(mu=0,sd=2). See details below.}

\item{adj.k}{when TRUE adjusts the prior specification for k >1 (or for k <1), default: adj.k = FALSE . See deatil below.}

\item{mc.params}{contains detials of MCMC parameters, default: mc.params=list(burn=1000, iter=10000, nc=2)}

\item{inf.type}{indicate inference type, default: inf.type =1 (gives conditional inference for fixed background rate). See deatil below.}

\item{plots}{indicates whether standard plots to be generated, default: plots= TRUE}

\item{prnt}{indicates whether inputs  to be printed, default: prnt= TRUE}
}
\value{
returns a dataframe of MCMC output from the posterior distribution for parameters of interests
}
\description{
Bayesian Detection of Risk using Inference on Blinded Safety data
}
\details{
This 'bdribs' package obtains Bayesian inferences on blinded pooled safety data  ...

Values of p.params are used to specify a beta prior for p - default is Jeffreys non-informative prior: Beta(a=0.5,b=0.5).

If inf.type=1, then conditional posterior inference on r is obtained for
     a given fixed values of del0 = bg.rate = bg.events/bg.pyr.

If inf.type=2, then an average (marginal) Bayesian inference on r is obtained with respect to a prior on del0, where
    del0 ~ Gamma(bg.events, bg.pyr).

If prior on r must be specified directly it can be done by using a log-normal prior. To do that, p.params must be set to NULL and
   and then r.params should be specifed as a list to supply mean and sd of the lognormal. For example, to have a lognormal prior
   with log-mean 0 and log-sd = 2, we should set r.params = list(mu=0, sd=2) and p.params=NULL.

when adj.k = TRUE, and k is not 1 (that is, allocation ratio is not 1:1), then
a non-informative prior such as (beta(.5, .5) is first specified on p, assuming equal allocation ratio and then adjusted for the give k.
When adj.k = F, then no such adjustment is made on the prior for p. Note that no such adjustments
needed if prior on r is directly specified (as discussed above). However, it is always difficult to
specify a non-informative prior on r and therefore a a prior on p with adj.k =T is recommended in most cases.
}
\examples{
## Sample calls
    #run 1: simple case with a fixed background rate of 0.45 per 100 pyr.
    bdribs(y=5,pyr=500, bg.rate=0.0045,k=2)

    #run 2: same as run 1; here bg.rate gets computed as bg.events/bg.pyr
    bdribs(y=5,pyr=500, bg.events = 18, bg.pyr = 4000, k=2)

    # run3: when inf.type = 2, uses a Gamma distribution for del0; e.g. here Gamma(18, 4000)
    bdribs(y=5,pyr=500, bg.events = 18, bg.pyr = 4000, k=2, inf.type = 2)

    #run4: similar to run1, but instead of default p~u(0,1) using p~beta(.5,.5)
    bdribs(y=5,pyr=500, , bg.rate=0.0045,k=2, p.params=list(a=.5,b=.5))

    #run5: similar to run1, but instead of default p ~ beta(.5,.5) using r ~ lognormal(mu=0,sd=2)
    bdribs(y=5,pyr=500, , bg.rate=0.0045,k=2, p.params= NULL, r.params=list(mu=0,sd=2))

}
\author{
Saurabh Mukhopadhyay
}
