% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_stripPnLatExpiration.R
\name{stripPnLatExpiration}
\alias{stripPnLatExpiration}
\title{Calculates per share Profit and Loss at expiration for Strip Option Strategy and draws its graph in the plots tab.}
\usage{
stripPnLatExpiration(
  ST,
  X,
  C,
  P1,
  P2,
  hl = 0,
  hu = 2,
  xlab = "Spot Price ($) at Expiration",
  ylab = "Profit / Loss ($) at Expiration",
  main = "Strip [PnL]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium or Call Price.}

\item{P1}{Put Premium on first Put.}

\item{P2}{Put Premium on second Put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This Strategy consists of a long call position (in an at-the-money call option) and a long position in two put options (at-the-money) with a strike price X. The Strip is a simple adjustment to the Straddle to make it more biased toward the downside. In buying a second put, the strategy retains its preference for high volatility but now with a more bearish slant (Cohen, 2016).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Strip Option Strategy and draw its graph in the plots tab. EXAMPLE, Buy HypoBeta December 9 call at $1.40 (outflow) and Buy two HypoBeta December 9 Puts at $0.80 (outflow). This is a net debit trade and involves three cash outflows. The graph gets displayed in Plots tab.
}
\examples{
stripPnLatExpiration(9,9,1.4,0.80,0.80)
stripPnLatExpiration(40,40,2,1.25,1.25,hl=0.9,hu=1.2)
stripPnLatExpiration(1000,1000,8,5.50,6.50,hl=0.985,hu=1.022)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
