% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_longPutPnLatExpiration.R
\name{longPutPnLatExpiration}
\alias{longPutPnLatExpiration}
\title{Calculates Profit and Loss (pnL) at expiration per share or unit of the underlying for European Put Buyer and draws its graph in the Plots tab.}
\usage{
longPutPnLatExpiration(
  ST,
  X,
  P,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [PnL] at Expiration ($)",
  main = "Long Put / Put Buyer [ PnL ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{P}{Put Premium or Put price.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
A Put option allows the holder, or long, to receive amount \code{X} by allowing the holder to sell the underlying asset at the exercise price. Thus, the holder should exercise the put at expiration if the underlying asset is worth less than the exercise price (ST < X). In that case, the put is said to be in-the-money. If the underlying asset is worth the same as the exercise price (ST = X), meaning the put is at-the-money, or more than the exercise price (ST > X), meaning the put is out-of-the-money, the option holder would not exercise it and it would expire with zero value. Thus, the Profit and Loss(PnL) to the Put Buyer (Holder) is equal to Maximum of (0, X - ST) minus Net Debit (V0Dr) (Chance, 2019).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute Profit and Loss (pnL) at expiration per share or unit of the underlying for European Put Buyer and draw its graph in the Plots tab. EXAMPLE, Buying HypoTech December 10 put at $2.00. Here \code{X} is the exercise price (strike price) of the option, \code{ST} is the price of the underlying at time T, and  \code{P} is the price (also called premium) paid by the European Put Buyer to the the Put Seller at time 0. The graph gets displayed in Plots tab.
}
\examples{
longPutPnLatExpiration(10,9,2)
longPutPnLatExpiration(40,38,3,hl=0.8,hu=1.2)
longPutPnLatExpiration(1000,1020,14,hl=0.995,hu=1.03)
}
\references{
Chance,D.M.(2019). Basics of Derivative Pricing and Valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 385-453). Wiley Professional Development (P&T). ISBN 9781119593577, https://bookshelf.vitalsource.com/books/9781119593577\cr
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
