% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_conf_int}
\alias{calc_conf_int}
\title{Calculate Confidence Intervals for a Parameter}
\usage{
calc_conf_int(estimate, std_error, model, alpha = 0.05)
}
\arguments{
\item{estimate}{A numeric value representing the parameter estimate.}

\item{std_error}{A numeric value representing the standard error of the parameter estimate.}

\item{model}{A fitted model object that provides the residual degrees of freedom via \code{df.residual()}.}

\item{alpha}{A numeric value representing the significance level. Default is 0.05 (95\% confidence interval).}
}
\value{
A numeric vector of length two:
\itemize{
\item First element: Lower bound of the confidence interval.
\item Second element: Upper bound of the confidence interval.
}
}
\description{
This function computes the lower and upper bounds of the confidence interval for a parameter estimate, given its standard error,
a specified significance level, and the degrees of freedom from the model.
}
\examples{
# Example using a linear model
data <- data.frame(x = 1:10, y = c(2.3, 2.1, 3.7, 4.5, 5.1, 6.8, 7.3, 7.9, 9.2, 10.1))
lm_model <- lm(y ~ x, data = data)
calc_conf_int(estimate = 0.5, std_error = 0.1, model = lm_model, alpha = 0.05)
}
