% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_document_info_df.R
\name{get_document_info_df}
\alias{get_document_info_df}
\title{Get Document Information DataFrame}
\usage{
get_document_info_df(model, texts, drop_expanded_columns = TRUE)
}
\arguments{
\item{model}{A BERTopic model object.}

\item{texts}{A character vector containing the preprocessed texts to be passed to the BERTopic model.}

\item{drop_expanded_columns}{Logical. If TRUE, drops the expanded columns after consolidation. Default is TRUE.}
}
\value{
A data.frame or tibble with unnested and consolidated columns.
}
\description{
This function retrieves document information from a BERTopic model and processes it to unnest
list columns, replace NA values, and consolidate columns with the same prefix.
}
\examples{
\donttest{
if (exists("topic_model") && exists("texts_cleaned")) {
  document_info_df <- get_document_info_df(
    model = topic_model,
    texts = texts_cleaned,
    drop_expanded_columns = TRUE
  )
  print(document_info_df)
} else {
  message("No topic_model/texts_cleaned found. Please train or load a model first.")
}
}
}

