% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{AMS}
\alias{AMS}
\title{Alpha Shape-Parameter Given Location-Parameters, Mean, and Variance a Four-Parameter Beta Probability Density Distribution.}
\usage{
AMS(mean, variance, l = 0, u = 1, sd = NULL)
}
\arguments{
\item{mean}{The mean (first raw moment) of the target Standard Beta probability density distribution.}

\item{variance}{The variance (second central moment) of the target Standard Beta probability density distribution.}

\item{l}{The lower-bound location parameter of the Beta distribution. Default is 0 (as it is for the Standard Beta distribution).}

\item{u}{The upper-bound location parameter of the Beta distribution. Default is 1 (as it is for the Standard Beta distribution).}

\item{sd}{Optional alternative to specifying \code{var}. The standard deviation of the target Standard Beta probability density distribution.}
}
\value{
A numeric value representing the required value for the Alpha shape-parameter in order to produce a  Beta probability density distribution with the target mean and variance, given specified lower- and upper bounds of the Beta distribution.
}
\description{
Calculates the Beta value required to produce a Beta probability density distribution with defined moments and parameters. Be advised that not all combinations of moments and parameters can be satisfied (e.g., specifying mean, variance, skewness and kurtosis uniquely determines both location-parameters, meaning that the value of the lower-location parameter will take on which ever value it must, and cannot be specified).
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0, rescaled to proportion
# of maximum.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, 0.25, 0.75, 5, 3)) / 100
hist(testdata, xlim = c(0, 1))

# To find the alpha shape-parameter of a Standard (two-parameter) Beta
# distribution with the same mean and variance as the observed-score
# distribution using AMS():
AMS(mean(testdata), var(testdata))
}
