% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{MLA}
\alias{MLA}
\title{Most Likely True Alpha Value Given Observed Outcome.}
\usage{
MLA(alpha, beta, x = NULL, n = NULL)
}
\arguments{
\item{alpha}{Observed alpha-parameter value for fitted Standard Beta Probability Density Distribution.}

\item{beta}{Observed beta-parameter value for fitted Standard Beta Probability Density Distribution.}

\item{x}{Observed proportion-correct outcome.}

\item{n}{Test-length.}
}
\value{
The Alpha shape-parameter value for the Standard Beta probability density distribution where the observed mean is the expected mode.
}
\description{
Given a fitted Standard (two-parameter) Beta Distribution, return the alpha shape-parameter value where the observed mean becomes the mode.
}
\examples{
# Assuming a prior Standard (two-parameter) Beta distribution is fit, which
# yield an alpha parameter of 10 and a beta parameter of 8, calculate the
# true-alpha parameter most likely to have produced the observations:
MLA(a = 10, b = 8)
}
