% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{confmat}
\alias{confmat}
\title{Confusion matrix}
\usage{
confmat(tp, tn, fp, fn, output = "freq")
}
\arguments{
\item{tp}{The frequency or rate of true-positive classifications.}

\item{tn}{The frequency or rate of true-negative classifications.}

\item{fp}{The frequency or rate of false-positive classifications.}

\item{fn}{The frequency or rate of false-negative classifications.}

\item{output}{Whether the returned output reflects frequencies or proportions. Defaults to returning frequencies.}
}
\value{
A confusion matrix organizing the input values of true and false positive and negatives.
}
\description{
Organizes supplied values of true and false positives and negatives into a confusion matrix.
}
\examples{
# Generate some true and observed conditions.
set.seed(1234)
true.ability <- rbeta(50, 4, 4)
true.category <- ifelse(true.ability < 0.5, 0, 1)
observed.score <- rbinom(50, 50, true.ability)
observed.category <- ifelse(observed.score < 25, 0, 1)
# Calculate the frequencies of true and false positives and negatives based on the true and
# observed conditions.
TP <- sum(ifelse(observed.category == 0 & true.category == 0, 1, 0))
FP <- sum(ifelse(observed.category == 0 & true.category != 0, 1, 0))
TN <- sum(ifelse(observed.category == 1 & true.category == 1, 1, 0))
FN <- sum(ifelse(observed.category == 1 & true.category != 1, 1, 0))
# Organize the above values in a confusion matrix using the confmat function:
confmat(tp = TP, fp = FP, tn = TN, fn = FN)
}
