% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.betapart.core.pairwise.R
\name{inter_geom}
\alias{inter_geom}
\title{Internal function to compute convexhull volume}
\usage{
inter_geom(ps1, ps2, options = "Tv", tol = 0, fp = NULL, qhull.opt = "n FA")
}
\arguments{
\item{ps1}{A matrix of coordinates.}

\item{ps2}{A second matrix of coordinates.}

\item{options}{Options pass to \code{\link[geometry]{halfspacen}}.}

\item{tol}{Tolerance, see \code{\link[geometry]{intersectn}}.}

\item{fp}{Coordinates of feasible point (NULL).}

\item{qhull.opt}{qhull options.}
}
\value{
the convex hull volume of the intersection of two hypervolumes
}
\description{
Estimation of the convexhull volume of the intersection of two hypervolumes based on the \code{\link[geometry]{intersectn}} function
}
\examples{
\dontrun{mat1 <- matrix(runif(30), 10)
mat2 <- matrix(runif(30), 10)
inter_geom(mat1, mat2)}
}
\seealso{
\code{\link{inter_rcdd}}, \code{\link[geometry]{intersectn}}
}
