% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powertbf01.R
\name{powertbf01}
\alias{powertbf01}
\title{Power and sample size calculations for \eqn{t}-test Bayes factor}
\usage{
powertbf01(
  n = NULL,
  power = NULL,
  k = 1/10,
  null = 0,
  plocation = 0,
  pscale = 1/sqrt(2),
  pdf = 1,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "less", "greater"),
  dpm = plocation,
  dpsd = pscale,
  nrange = c(2, 10^4)
)
}
\arguments{
\item{n}{Sample size (per group)}

\item{power}{Target power. Has to be \code{NULL} if \code{n} is specified.
Defaults to \code{NULL}}

\item{k}{Bayes factor threshold. Defaults to \code{1/10}, Jeffreys' threshold
for 'strong evidence' against the null hypothesis}

\item{null}{Standardized mean difference under the point null hypothesis.
Defaults to \code{0}}

\item{plocation}{\eqn{t} prior location. Defaults to \code{0}}

\item{pscale}{\eqn{t} prior scale. Defaults to \code{1/sqrt(2)}}

\item{pdf}{\eqn{t} prior degrees of freedom. Defaults to \code{1} (a Cauchy
prior)}

\item{type}{Type of \eqn{t}-test. Can be \code{"two.sample"} (default),
\code{"one.sample"}, or \code{"paired"}}

\item{alternative}{Direction of the test. Can be either \code{"two.sided"}
(default), \code{"less"}, or \code{"greater"}. The latter two truncate
the analysis prior to negative and positive effects, respectively. If set
to \code{"less"} or \code{"greater"}, the power is only computed based on
data with effect estimates in the direction of the alternative}

\item{dpm}{Mean of the normal design prior assigned to the standardized mean
difference. Defaults to the analysis prior location}

\item{dpsd}{Standard deviation of the normal design prior assigned to the
standardized mean difference. Set to \code{0} to obtain a point prior at
the design prior mean. Defaults to the analysis prior scale}

\item{nrange}{Sample size search range over which numerical search is
performed (only taken into account when \code{n} is \code{NULL}).
Defaults to \code{c(2, 10^4)}}
}
\value{
Object of class \code{"power.bftest"}, a list of the arguments
    (including the computed one) augmented with \code{method} and \code{note}
    elements
}
\description{
Compute probability that \eqn{t}-test Bayes factor is smaller
    than a specified threshold (the power), or determine sample size to
    obtain a target power.
}
\details{
This function provides a similar interface as
    \code{stats::power.t.test}. For some users, the low-level functions
    \link{ntbf01} (to directly compute the sample size for a fixed power) and
    \link{ptbf01} (to directly compute the power for a fixed sample size) may
    also be useful.
}
\examples{
## determine power
powertbf01(n = 146, k = 1/6, dpm = 0.5, dps = 0, alternative = "greater")

## determine sample size
powertbf01(power = 0.95, k = 1/6, dpm = 0.5, dps = 0, alternative = "greater")

}
\seealso{
\link{plot.power.bftest}, \link{ptbf01}, \link{ntbf01}, \link{tbf01}
}
\author{
Samuel Pawel
}
