\name{ars}
\alias{ars}
\alias{arns}
\alias{rpwexp}
\title{Function to perform Adaptive Rejection Sampling}
\description{
Generates a sequence of random variables using Adaptive Rejection Sampling (ARS). 
}
\usage{
ars(logpdf, n = 1, lower=-14, upper=15, x0 = 0, ...)
arns(logpdf, n = 1, lower = -5, upper = 5, sigma.offset = 0.05, 
              fx.offset = 0.03, K = 100, verbose = FALSE, ...)
}
\arguments{
  \item{n}{Desired sample size.}
  \item{x0}{Initial point.}
  \item{logpdf}{Univariate log target density.}
  \item{lower}{lower limit of the random variable.}
  \item{upper}{upper limit of the random variable.}
  \item{sigma.offset}{offset of sigma for the normal envelope function to ensure it covers the logpdf.}
  \item{fx.offset}{offset of maximum for the normal envelope function to ensure it covers the logpdf.}
  \item{K}{number of points between lower and upper to evaluate logpdf to find the peak and bottom values.}
  \item{verbose}{print out the verbose, default is FALSE.}
  \item{...}{Parameters passed to \code{logpdf}}
}
\details{
The support of the target density must be a bounded convex set. 
When this is not the case, the following tricks usually work.
If the support is not bounded, restrict it to a bounded set having probability 
practically one. 
A workaround, if the support is not convex, is to consider the convex set 
generated by the support. 

Make sure the value returned by \code{logpdf} is never smaller than
\code{log(.Machine$double.xmin)}, to avoid divisions by zero.
}
\value{
An \code{n} vector, whose elements are the sampled points.
}
\references{
Gilks, W.R., Best, N.G. and Tan, K.K.C. (1995)
Adaptive rejection Metropolis sampling within Gibbs sampling
  (Corr: 97V46 p541-542 with Neal, R.M.), \emph{Applied Statistics}
  \bold{44}:455--472.
}

\author{Bingshu E. Chen \email{bingshu.chen@queensu.ca}}
%\note{The function is based on original C code by Wally Gilks for the univariate case.}

\examples{
#### ==> Warning: running the examples may take a few minutes! <== ####    
### Univariate densities
## Normal(mean,1)
normlogdens <- function(x, mean) -(x-mean)^2/2 
y <- ars(normlogdens, n = 10, mean = 3.0)
summary(y); 
}

\keyword{distribution}% at least one, from doc/KEYWORDS
\keyword{piecewise linear}% __ONLY ONE__ keyword per line
\keyword{misc}
