% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{bids_transform}
\alias{bids_transform}
\title{Apply a transformation to BIDS files}
\usage{
bids_transform(x, transformer, pipeline_name, ...)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{transformer}{A function that performs the transformation. It must take
the input file path and return the output file path. The transformer is
responsible for creating the output file.}

\item{pipeline_name}{The name for the new derivative pipeline.}

\item{...}{Additional arguments passed to \code{\link{search_files}} to select
files (e.g., \code{subid = "01"}, \code{task = "rest"}).}
}
\value{
A character vector of paths to the newly created files.
}
\description{
This function orchestrates the process of selecting files from a BIDS project,
applying a transformation to each file, and saving the output in a new BIDS
derivative directory. It leverages the existing bidser parsing and search
infrastructure.
}
\examples{
\donttest{
tryCatch({
  ds_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds_path)

  # Create a simple transformer that adds a description
  add_desc_transformer <- function(infile) {
    entities <- encode(basename(infile))
    entities$desc <- if (is.null(entities$desc)) "smooth6mm" else 
                     paste(entities$desc, "smooth6mm", sep="")
    
    # Generate new filename
    new_name <- decode_bids_entities(entities)
    outfile <- file.path(dirname(infile), new_name)
    
    # For demo, just copy the file (real transformer would process it)
    file.copy(infile, outfile)
    return(outfile)
  }

  # Apply transformation to functional files for subject 01
  new_files <- bids_transform(proj, add_desc_transformer, "smoothed",
                              subid = "01", suffix = "bold.nii.gz")
  print(length(new_files))

}, error = function(e) {
  message("Example failed: ", e$message)
})
}
}
