% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class034-bids_scans.R
\name{BIDSTabularScans}
\alias{BIDSTabularScans}
\title{'BIDS' scans table class}
\usage{
BIDSTabularScans(content, meta = NULL)
}
\arguments{
\item{content, meta}{see \code{\link{BIDSTabular}}}
}
\value{
A \code{BIDSTabularScans} instance inheriting
\code{\link{BIDSTabular}}.
}
\description{
A tabular containing a list of scans and their metadata.
The class is a child class of \code{\link{BIDSTabular}}, hence see
the methods there.
The original specification is at
\url{https://bids-specification.readthedocs.io/en/stable/modality-agnostic-files.html#scans-file}.
}
\examples{


# basic
tabular <- BIDSTabularScans(
  data.frame(
    filename = c(
      "func/sub-control01_task-nback_bold.nii.gz",
      "func/sub-control01_task-motor_bold.nii.gz",
      "meg/sub-control01_task-rest_split-01_meg.nii.gz"
    ),
    acq_time = c(
      "1877-06-15T13:45:30",
      "1877-06-15T13:55:33",
      "1877-06-15T12:15:27"
    )
  )
)

# No ending Z, time is interpreted as local time
# tabular uses UTC time
tabular


# convert existing tabular
tabular <- BIDSTabular(
  data.frame(
    filename = "func/sub-control01_task-nback_bold.nii.gz",
    acq_time = "1877-06-15T13:45:30"
  )
)
tabular <- as_bids_tabular(tabular, cls = BIDSTabularScans)
tabular

# save to tsv
tsv <- file.path(tempdir(), "scans.tsv")
paths <- save_bids_tabular(tabular, tsv)

print(paths)


# use base R to read
read.table(tsv, header = TRUE, na.strings = "n/a")

# get sidecar
cat(readLines(paths$sidecar_path), sep = "\n")


# clean up
unlink(tsv)
unlink(paths$sidecar_path)



}
\author{
Zhengjia Wang
}
