% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_validate.R
\name{bid_validate}
\alias{bid_validate}
\title{Document User Validation Stage in BID Framework}
\usage{
bid_validate(
  previous_stage,
  summary_panel = NULL,
  collaboration = NULL,
  next_steps = NULL,
  include_exp_design = TRUE,
  include_telemetry = TRUE,
  telemetry_refs = NULL,
  include_empower_tools = TRUE,
  quiet = NULL
)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function.}

\item{summary_panel}{A character string describing the final summary panel
or key insight presentation.}

\item{collaboration}{A character string describing how the dashboard enables
collaboration and sharing.}

\item{next_steps}{A character vector or string describing recommended next
steps for implementation and iteration.}

\item{include_exp_design}{Logical indicating whether to include experiment
design suggestions. Default is TRUE.}

\item{include_telemetry}{Logical indicating whether to include telemetry
tracking and monitoring suggestions. Default is TRUE.}

\item{telemetry_refs}{Optional character vector or named list specifying
specific telemetry reference points to include in validation steps.
If provided, these will be integrated into the telemetry tracking
recommendations with provenance information.}

\item{include_empower_tools}{Logical indicating whether to include
context-aware empowerment tool suggestions. Default is TRUE.}

\item{quiet}{Logical indicating whether to suppress informational messages.
If NULL, uses getOption("bidux.quiet", FALSE).}
}
\value{
A tibble containing the documented information for the "Validate"
stage.
}
\description{
This function documents the validation stage, where the user tests and
refines the dashboard. It represents stage 5 in the BID framework.
}
\examples{
validate_result <- bid_interpret(
  central_question = "How can we improve delivery efficiency?",
  data_story = new_data_story(
    hook = "Too many delays",
    context = "Excessive shipments",
    tension = "User frustration",
    resolution = "Increase delivery channels"
  )
) |>
  bid_notice(
    problem  = "Issue with dropdown menus",
    evidence = "User testing indicated delays"
  ) |>
  bid_anticipate(
    bias_mitigations = list(
      anchoring = "Provide reference points",
      framing = "Use gain-framed messaging"
    )
  ) |>
  bid_structure() |>
  bid_validate(
    include_exp_design = FALSE,
    include_telemetry = TRUE,
    include_empower_tools = TRUE
  )

summary(validate_result)

}
