% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{convert_otel_spans_to_events}
\alias{convert_otel_spans_to_events}
\title{Convert OTLP spans to bidux event schema}
\usage{
convert_otel_spans_to_events(spans_df)
}
\arguments{
\item{spans_df}{Data frame of OTLP spans with columns:
\itemize{
\item name: span name (e.g., "session_start", "output:plot1")
\item startTimeUnixNano: start timestamp in Unix nanoseconds
\item endTimeUnixNano: end timestamp in Unix nanoseconds
\item attributes: list column with span attributes
\item events: list column with span events (for errors)
}}
}
\value{
Tibble with bidux event schema columns:
\itemize{
\item timestamp: POSIXct event timestamp
\item session_id: character session identifier
\item event_type: character event type (login, input, output, error)
\item input_id: character input identifier (NA for non-input events)
\item value: character/numeric value (NA for most otel spans)
\item error_message: character error message (NA for non-error events)
\item output_id: character output identifier (NA for non-output events)
\item navigation_id: character navigation identifier (NA for otel spans)
}
}
\description{
Converts OpenTelemetry Protocol (OTLP) span data to the bidux telemetry event schema.
This enables transparent compatibility with existing friction detection algorithms.
This function is called automatically by \code{\link[=bid_telemetry]{bid_telemetry()}} and \code{\link[=bid_ingest_telemetry]{bid_ingest_telemetry()}}
when OTLP data is detected - you rarely need to call it directly.

\strong{Automatic Format Detection}: When you pass OTLP JSON or SQLite to \code{\link[=bid_telemetry]{bid_telemetry()}},
this conversion happens automatically. The same UX friction detection algorithms work
seamlessly on both shiny.telemetry events and OpenTelemetry spans.

\strong{Span to Event Mapping}:
\itemize{
\item session_start -> login
\item output -> output
\item reactive, observe -> input
\item reactive_update -> synthetic timing events
\item Error span events -> error
}
}
\examples{
\dontrun{
# Typically you don't need to call this directly - use bid_telemetry() instead:
issues <- bid_telemetry("otel_spans.json")

# Manual conversion (advanced use case):
# After reading otlp json file
spans <- read_otel_json("spans.json")
events <- convert_otel_spans_to_events(spans)

# Verify schema compatibility
names(events)
# [1] "timestamp" "session_id" "event_type" "input_id" "value" "error_message"
# [7] "output_id" "navigation_id"

# Now use standard friction detection
issues <- detect_telemetry_issues(events)
}

}
\seealso{
\itemize{
\item \code{\link[=bid_telemetry]{bid_telemetry()}} for high-level telemetry analysis (automatic format detection)
\item \code{\link[=bid_ingest_telemetry]{bid_ingest_telemetry()}} for legacy telemetry workflows
\item \code{vignette("otel-integration")} for complete OTEL setup guide
}
}
