% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{extract_error_message_from_span}
\alias{extract_error_message_from_span}
\title{Extract error message from span events}
\usage{
extract_error_message_from_span(span_events)
}
\arguments{
\item{span_events}{List or data frame of span events}
}
\value{
Character error message, or NA if no error found
}
\description{
Extracts error messages from OTLP span events. Error events contain
the error details in their attributes.
}
\examples{
\dontrun{
events <- list(
  list(
    name = "error",
    attributes = list(
      list(key = "message", value = list(stringValue = "Division by zero"))
    )
  )
)
extract_error_message_from_span(events) # returns "Division by zero"
}
}
\keyword{internal}
