% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{extract_output_id_from_span}
\alias{extract_output_id_from_span}
\title{Extract output ID from span name or attributes}
\usage{
extract_output_id_from_span(span_name, span_attributes)
}
\arguments{
\item{span_name}{Character span name}

\item{span_attributes}{List or data frame of span attributes}
}
\value{
Character output ID, or NA if not found
}
\description{
Extracts output identifier from OTLP span. Looks in span name (e.g., "output:plot1")
and span attributes (e.g., output_id attribute).
}
\examples{
\dontrun{
# extract from span name
extract_output_id_from_span("output:plot1", NULL) # returns "plot1"

# extract from attributes
attrs <- list(list(key = "output_id", value = list(stringValue = "table1")))
extract_output_id_from_span("output", attrs) # returns "table1"
}
}
\keyword{internal}
