% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{pca_robust}
\alias{pca_robust}
\title{Robust principal component analysis}
\usage{
pca_robust(x, center = TRUE, scale = FALSE, ncomp = NULL)
}
\arguments{
\item{x}{A numeric matrix, data frame, or an object coercible to a numeric
matrix. Missing values are not supported.}

\item{center}{Logical; should variables be centred by their median before
applying PCA?}

\item{scale}{Logical; when \code{TRUE}, variables are scaled by the MAD after
centring. Scaling requires \code{center = TRUE}.}

\item{ncomp}{Number of components to retain. Use \code{NULL} or a non-positive
value to keep all components returned by the decomposition.}
}
\value{
A \code{\link{bigpca}} object mirroring the structure of
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}} with robust estimates of location, scale, and
variance metrics.
}
\description{
Compute principal component analysis (PCA) using robust measures of location
and scale so that extreme observations have a reduced influence on the
resulting components. The implementation centres each variable by its median
and, when requested, scales by the median absolute deviation (MAD) before
performing an iteratively reweighted singular value decomposition that
down-weights observations with unusually large reconstruction errors.
}
\examples{
set.seed(42)
x <- matrix(rnorm(50), nrow = 10)
x[1, 1] <- 25  # outlier
robust <- pca_robust(x, ncomp = 2)
robust$sdev

}
