% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.stat.R
\name{colmin}
\alias{colmin}
\alias{colmin,min,colmax,max,colprod,prod,colsum,sum,colrange,range,colmean,mean,colvar,var,colsd,sd,colna,summary}
\alias{colmin,big.matrix-method}
\alias{min,big.matrix-method}
\alias{colmax}
\alias{colmax,big.matrix-method}
\alias{max,big.matrix-method}
\alias{colprod}
\alias{colprod,big.matrix-method}
\alias{prod,big.matrix-method}
\alias{colsum}
\alias{colsum,big.matrix-method}
\alias{sum,big.matrix-method}
\alias{colrange}
\alias{colrange,big.matrix-method}
\alias{range,big.matrix-method}
\alias{colmean}
\alias{colmean,big.matrix-method}
\alias{mean,big.matrix-method}
\alias{colvar}
\alias{colvar,big.matrix-method}
\alias{colsd}
\alias{colsd,big.matrix-method}
\alias{colna}
\alias{colna,big.matrix-method}
\alias{summary,big.matrix-method}
\title{Basic summary statistics for ``big.matrix'' objects}
\usage{
colmin(x, cols = NULL, na.rm = FALSE)

\S4method{colmin}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{min}{big.matrix}(x, ..., na.rm = FALSE)

colmax(x, cols = NULL, na.rm = FALSE)

\S4method{colmax}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{max}{big.matrix}(x, ..., na.rm = FALSE)

colprod(x, cols = NULL, na.rm = FALSE)

\S4method{colprod}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{prod}{big.matrix}(x, ..., na.rm = FALSE)

colsum(x, cols = NULL, na.rm = FALSE)

\S4method{colsum}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{sum}{big.matrix}(x, ..., na.rm = FALSE)

colrange(x, cols = NULL, na.rm = FALSE)

\S4method{colrange}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{range}{big.matrix}(x, ..., na.rm = FALSE)

colmean(x, cols = NULL, na.rm = FALSE)

\S4method{colmean}{big.matrix}(x, cols = NULL, na.rm = FALSE)

\S4method{mean}{big.matrix}(x, ...)

colvar(x, cols = NULL, na.rm = FALSE)

\S4method{colvar}{big.matrix}(x, cols = NULL, na.rm = FALSE)

colsd(x, cols = NULL, na.rm = FALSE)

\S4method{colsd}{big.matrix}(x, cols = NULL, na.rm = FALSE)

colna(x, cols = NULL)

\S4method{colna}{big.matrix}(x, cols = NULL)

\S4method{summary}{big.matrix}(object)
}
\arguments{
\item{x}{a \code{\link[bigmemory]{big.matrix}} object.}

\item{cols}{a scalar or vector of column(s) to be summarized.}

\item{na.rm}{if \code{TRUE}, remove \code{NA} values before summarizing.}

\item{\dots}{options associated with the correspoding default \R function.}

\item{object}{a \code{\link[bigmemory]{big.matrix}} object.}
}
\value{
For \code{colrange}, a matrix with two columns and 
\code{length(cols)} rows; column 1 contains the minimum, and column 2 
contains the maximum for that column.  The other functions return vectors 
of length \code{length(cols)}.
}
\description{
Functions operate on columns of a 
\code{\link[bigmemory]{big.matrix}} object
}
\details{
These functions essentially apply summary functions to each 
column (or each specified column) of the 
\code{\link[bigmemory]{big.matrix}} in turn.
}
\examples{
x <- as.big.matrix(
  matrix( sample(1:10, 20, replace=TRUE), 5, 4,
          dimnames=list( NULL, c("a", "b", "c", "d")) ) )
x[,]
mean(x)
colmean(x)
colmin(x)
colmin(x, 1)
colmax(x)
colmax(x, "b")
colsd(x)
colrange(x)
range(x)
colsum(x)
colprod(x)
}
