% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{PoissonBlocICL}
\alias{PoissonBlocICL}
\title{PoissonBlocICL function for the computation of the ICL criterion in the Poisson LBM}
\usage{
PoissonBlocICL(a,alpha,beta,x,v1,w1,normalization)
}
\arguments{
\item{a}{hyperparameter used in the VBayes algorithm for priors on the mixing proportions. By default, a=4.}

\item{alpha}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter. By default, alpha=1.}

\item{beta}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter. By default, beta=0.01.}

\item{x}{contingency matrix of observations.}

\item{v1}{a numeric vector specifying the class of rows.}

\item{w1}{a numeric vector specifying the class of columns.}

\item{normalization}{logical. To use the normalized Poisson modelling in the Latent Block Model. By default normalization=FALSE.}
}
\value{
a value of the ICL criterion
}
\description{
Produce a value of the ICL criterion for co-clustering partitions
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=(1/h)*matrix(1,h,1)
theta$tau_l=(1/l)*matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,4,4,4,init_choice='smallVBayes')
icl=PoissonBlocICL(4,1,0.01,data$x,res@model_max$v,res@model_max$w, normalization=FALSE)}
}
