% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_binomialRF.R
\name{.cv_binomialRF}
\alias{.cv_binomialRF}
\title{random forest feature selection based on binomial exact test}
\usage{
.cv_binomialRF(X, y, cvFolds = 5, fdr.threshold = 0.05,
  fdr.method = "BY", ntrees = 2000, keep.both = FALSE)
}
\arguments{
\item{X}{design matrix}

\item{y}{class label}

\item{cvFolds}{how many times should we perform cross-validation}

\item{fdr.threshold}{fdr.threshold for determining which set of features are significant}

\item{fdr.method}{how should we adjust for multiple comparisons (i.e., \code{p.adjust.methods} =c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none"))}

\item{ntrees}{how many trees should be used to grow the \code{randomForest}? (Defaults to 5000)}

\item{keep.both}{should we keep the naive binomialRF as well as the correlated adjustment}
}
\value{
a data.frame with 4 columns: Feature Name, cross-validated average for Frequency Selected, CV Median (Probability of Selecting it randomly), CV Median(Adjusted P-value based on \code{fdr.method}), and averaged number of times selected as signficant.
}
\description{
\code{cv.binomialRF} is the cross-validated form of the \code{binomialRF}, where K-fold crossvalidation is conducted to assess the feature's significance. Using the \code{cvFolds}=K parameter, will result in a K-fold cross-validation where the data is 'chunked' into K-equally sized groups and then the averaged result is returned.
}
\examples{
set.seed(324)

###############################
### Generate simulation data
###############################

X = matrix(rnorm(1000), ncol=10)
trueBeta= c(rep(10,5), rep(0,5))
z = 1 + X \%*\% trueBeta
pr = 1/(1+exp(-z))
y = as.factor(rbinom(100,1,pr))

###############################
### Run cross-validation
###############################

}
\references{
Zaim, SZ; Kenost, C.; Lussier, YA; Zhang, HH. binomialRF: Scalable Feature Selection and Screening for Random Forests to Identify Biomarkers and Their Interactions, bioRxiv, 2019.
}
