% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_multigrams.R
\name{count_multigrams}
\alias{count_multigrams}
\title{Detect and count multiple n-grams in sequences}
\usage{
count_multigrams(
  ns,
  ds = rep(0, length(ns)),
  seq,
  u,
  pos = FALSE,
  scale = FALSE,
  threshold = 0
)
}
\arguments{
\item{ns}{\code{numeric} vector of n-grams' sizes. See Details.}

\item{ds}{\code{list} of distances between elements of n-grams. Each element of the list
is a vector used as distance for the respective n-gram size given by the \code{ns}
parameter.}

\item{seq}{a vector or matrix describing sequence(s).}

\item{u}{\code{integer}, \code{numeric} or \code{character} vector of all
possible unigrams.}

\item{pos}{\code{logical}, if \code{TRUE} position-specific n_grams are counted.}

\item{scale}{\code{logical}, if \code{TRUE} output data is normalized. May be
applied only to the counts of n-grams without position information. See \code{Details}.}

\item{threshold}{\code{integer}, if not equal to 0, data is binarized into
two groups (larger or equal to threshold vs. smaller than threshold).}
}
\value{
An \code{integer} matrix with named columns. The naming conventions are the same
as in \code{\link{count_ngrams}}.
}
\description{
A convinient wrapper around \code{\link{count_ngrams}} for counting multiple
values of \code{n} and \code{d}.
}
\details{
\code{ns} vector and \code{ds} vector must have equal length. Elements of 
\code{ds} vector are used as equivalents of \code{d} parameter for respective values 
of \code{ns}. For example, if \code{ns} is \code{c(4, 4, 4)}, the \code{ds} must be a list of 
length 3. Each element of the \code{ds} list must have length 3 or 1, as appropriate
for a \code{d} parameter in \code{count_ngrams} function.
}
\examples{
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
count_multigrams(c(3, 1), list(c(1, 0), 0), seqs, 1L:4, pos = TRUE)
# if ds parameter is not present, n-grams are calculated for distance 0
count_multigrams(c(3, 1), seq = seqs, u = 1L:4)

# calculate three times n-gram with the same length, but different distances between
# elements
count_multigrams(c(4, 4, 4), list(c(2, 0, 1), c(2, 1, 0), c(0, 1, 2)), 
                 seqs, 1L:4, pos = TRUE)
}
